/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.log;

import io.gitlab.jfronny.commons.logger.SystemLoggerPlus;
import io.gitlab.jfronny.libjf.log.EarlyLoggerSetup;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JULBridge
extends Handler {
    private final Module module = JULBridge.class.getClassLoader().getUnnamedModule();
    private final EarlyLoggerSetup loggerFinder = new EarlyLoggerSetup();

    public static void install() {
        Logger rootLogger = JULBridge.getRootLogger();
        rootLogger.addHandler(new JULBridge());
        boolean bridgeFound = false;
        for (Handler handler : rootLogger.getHandlers()) {
            if (handler instanceof JULBridge) {
                bridgeFound = true;
                continue;
            }
            rootLogger.removeHandler(handler);
        }
        if (!bridgeFound) {
            rootLogger.addHandler(new JULBridge());
        }
    }

    private static Logger getRootLogger() {
        return LogManager.getLogManager().getLogger("");
    }

    private JULBridge() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private SystemLoggerPlus getLoggerFor(LogRecord record) {
        return this.loggerFinder.getLogger(Objects.requireNonNullElse(record.getLoggerName(), ""), this.module);
    }

    private static System.Logger.Level getLevel(LogRecord record) {
        System.Logger.Level level = record.getLevel().equals(Level.OFF) ? System.Logger.Level.OFF : (record.getLevel().equals(Level.ALL) ? System.Logger.Level.ALL : (record.getLevel().intValue() >= Level.SEVERE.intValue() ? System.Logger.Level.ERROR : (record.getLevel().intValue() >= Level.WARNING.intValue() ? System.Logger.Level.WARNING : (record.getLevel().intValue() >= Level.INFO.intValue() ? System.Logger.Level.INFO : System.Logger.Level.DEBUG))));
        return level;
    }

    @Override
    public void publish(LogRecord record) {
        if (record == null) {
            return;
        }
        SystemLoggerPlus logger = this.getLoggerFor(record);
        System.Logger.Level level = JULBridge.getLevel(record);
        String message = record.getMessage();
        ResourceBundle bundle = null;
        if (message == null) {
            message = "";
        } else {
            bundle = record.getResourceBundle();
        }
        Object[] params = record.getParameters();
        Throwable thrown = record.getThrown();
        if (thrown == null) {
            logger.log(level, bundle, message, params);
        } else {
            logger.log(level, bundle, message, thrown, params);
        }
    }
}

